/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.BlockInfo;
import carpet.utils.DistanceCalculator;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

public class WoolTool {
    private static final Map<class_3620, class_1767> Material2Dye = Arrays.stream(class_1767.values()).collect(Collectors.toUnmodifiableMap(class_1767::method_7794, Function.identity()));
    public static final Map<class_3620, String> Material2DyeName = Map.ofEntries(Map.entry(class_3620.field_16022, "w "), Map.entry(class_3620.field_15987, "#F9801D "), Map.entry(class_3620.field_15998, "m "), Map.entry(class_3620.field_16024, "t "), Map.entry(class_3620.field_16010, "y "), Map.entry(class_3620.field_15997, "l "), Map.entry(class_3620.field_16030, "#FFACCB "), Map.entry(class_3620.field_15978, "f "), Map.entry(class_3620.field_15993, "g "), Map.entry(class_3620.field_16026, "c "), Map.entry(class_3620.field_16014, "p "), Map.entry(class_3620.field_15984, "v "), Map.entry(class_3620.field_15977, "#835432 "), Map.entry(class_3620.field_15995, "e "), Map.entry(class_3620.field_16020, "r "), Map.entry(class_3620.field_16009, "k "));

    public static void carpetPlacedAction(class_1767 color, class_1657 placer, class_2338 pos, class_3218 worldIn) {
        if (!CarpetSettings.carpets) {
            return;
        }
        switch (color) {
            case field_7954: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.report(pos, worldIn));
                break;
            }
            case field_7963: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.show_mobcaps(pos, worldIn));
                break;
            }
            case field_7957: {
                if ("false".equals(CarpetSettings.commandDistance)) break;
                class_2168 source = placer.method_5671();
                if (!DistanceCalculator.hasStartingPoint(source) || placer.method_5715()) {
                    DistanceCalculator.setStart(source, class_243.method_24954((class_2382)pos));
                    break;
                }
                DistanceCalculator.setEnd(source, class_243.method_24954((class_2382)pos));
                break;
            }
            case field_7944: {
                if ("false".equals(CarpetSettings.commandInfo)) break;
                Messenger.send(placer, BlockInfo.blockInfo(pos.method_10074(), worldIn));
                break;
            }
            case field_7942: {
                if (!CarpetSettings.hopperCounters) break;
                class_1767 under = WoolTool.getWoolColorAtPosition((class_1937)worldIn, pos.method_10074());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under.toString());
                if (counter == null) break;
                Messenger.send(placer, counter.format(worldIn.method_8503(), false, false));
                break;
            }
            case field_7964: {
                if (!CarpetSettings.hopperCounters) break;
                class_1767 under = WoolTool.getWoolColorAtPosition((class_1937)worldIn, pos.method_10074());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under.toString());
                if (counter == null) {
                    return;
                }
                counter.reset(placer.method_5682());
                ArrayList<class_2561> res = new ArrayList<class_2561>();
                res.add(Messenger.s(String.format("%s counter reset", under.toString())));
                Messenger.send(placer, res);
            }
        }
    }

    public static class_1767 getWoolColorAtPosition(class_1937 worldIn, class_2338 pos) {
        class_2680 state = worldIn.method_8320(pos);
        if (state.method_26207() != class_3614.field_15931 || !state.method_26212((class_1922)worldIn, pos)) {
            return null;
        }
        return Material2Dye.get(state.method_26205((class_1922)worldIn, pos));
    }
}

